%{
This m-file belongs to Chapter 4 of the dissertation 'Electrochemical CO2
conversion with a flow-through copper hollow fibre'
Anne Sustronk (1,2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figure 1 in the chapter

The next files are required to execute this file: ConstantPotentialCO2.m
and CalcErr.m

Note that the file location in ConstantPotentialCO2.m (lines 41, 70, 75 
and 80) should be added before execution of Fig1.m.

Brief overview of experimental conditions: Cu hollow fiber working 
electrode, 0.5M or 2 M KHCO3  in MilliQ water, CO2 purged through fiber, 
chronoamperometry

Note that the flow rate to calculate the partial current densities is set
to 30 ml min-1. This is most likely an underestimation of the actual flow
rate at more negative potentials

Version date m-file: April 5, 2023
%}

clear all, clc, close all

%% Size for figure

size = 6;   % Width (in cm)

%% File location and name

%% Data from 0.5M KHCO3 exp; CO2 flown through fibre

% Retrieve file paths
KHCO3.CO2Through.Folder1 = '\CO2 flow through\0.5M KHCO3';
KHCO3.CO2Through.Folder2 = {'\-1.8V';'\-2.0V';'\-2.2V';'\-2.4V';'\-2.6V';'\-2.8V'};

% Retrieve file names potentiostat data
KHCO3.CO2Through.FileNameEC = {'\Fiber221114-3 CO2 FT KHCO3 -1_03_CA_C08.txt';
    '\Fiber221114-2 CO2 FT KHCO3 -2_0V_03_CA_C08.txt';
    '\Fiber221114-3 CO2 FT KHCO3 -2_2V_03_CA_C08.txt';
    '\Fiber221114-2 CO2 FT KHCO3 -2_4V_03_CA_C08.txt';
    '\Fiber221114-3 CO2 FT KHCO3 -2_6V_03_CA_C08.txt';
    '\Fiber221114-2 CO2 FT KHCO3 -2_8V_03_CA_C08.txt'};

% Geometric area (cm^2)
KHCO3.CO2Through.Area(1,1) = 0.911*mean([0.144 0.146])*pi();
KHCO3.CO2Through.Area(3,1) = KHCO3.CO2Through.Area(1,1);
KHCO3.CO2Through.Area(5,1) = KHCO3.CO2Through.Area(1,1);

KHCO3.CO2Through.Area(2,1) = 1.155*mean([0.147 0.148])*pi();
KHCO3.CO2Through.Area(4,1) = KHCO3.CO2Through.Area(2,1);
KHCO3.CO2Through.Area(6,1) = KHCO3.CO2Through.Area(2,1);

% Estimated error in geometric area (cm^2)
KHCO3.CO2Through.AreaErr(1,1) = 0.1*mean([0.144 0.146])*pi();
KHCO3.CO2Through.AreaErr(3,1) = KHCO3.CO2Through.AreaErr(1,1);
KHCO3.CO2Through.AreaErr(5,1) = KHCO3.CO2Through.AreaErr(1,1);

KHCO3.CO2Through.AreaErr(2,1) = 0.1*mean([0.147 0.148])*pi();
KHCO3.CO2Through.AreaErr(4,1) = KHCO3.CO2Through.AreaErr(2,1);
KHCO3.CO2Through.AreaErr(6,1) = KHCO3.CO2Through.AreaErr(2,1);

% Set variable name
KHCO3.CO2Through.VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04';'Exp05'; 'Exp06'];

% Uncorrected potential used during chronoamperometry
KHCO3.CO2Through.ESet = [-1.8; -2.0; -2.2; -2.4; -2.6; -2.8];

% Call ConstantPotentialCO2.m
KHCO3.CO2Through = ConstantPotentialCO2(KHCO3.CO2Through);

%% Data from 2M KHCO3 exp; CO2 flown through fibre

% Retrieve file paths
KHCO3.CO2Through2M.Folder1 = '\CO2 flow through\2M KHCO3';
KHCO3.CO2Through2M.Folder2 = {'\-1.8V';'\-2.0V';'\-2.1V';'\-2.2V';'\-2.4V'};

% Retrieve file names potentiostat data
KHCO3.CO2Through2M.FileNameEC = {'\Fiber22xxxx-x CO2 FT 2M KHCO3 -1_8V vs Ag_AgCl_03_CA_C08.txt';
    '\Fiber221114-5 CO2 FT 2M KHCO3 -2_0V vs Ag_AgCl_04_CA_C08.txt';
    '\Fiber22xxxx-x CO2 FT 2M KHCO3 -2_1V vs Ag_AgCl_03_CA_C08.txt';
    '\Fiber221114-5 CO2 FT 2M KHCO3 -2_2V vs Ag_AgCl_04_CA_C08.txt';
    '\Fiber22xxxx-x CO2 FT 2M KHCO3 -2_4V vs Ag_AgCl_03_CA_C08.txt'};

% Geometric area (cm^2)
KHCO3.CO2Through2M.Area(1,1) = 1.163*mean([0.150 0.146])*pi();
KHCO3.CO2Through2M.Area(3,1) = KHCO3.CO2Through2M.Area(1,1);
KHCO3.CO2Through2M.Area(5,1) = KHCO3.CO2Through2M.Area(1,1);

KHCO3.CO2Through2M.Area(2,1) = 0.946*mean([0.150 0.146])*pi();
KHCO3.CO2Through2M.Area(4,1) = KHCO3.CO2Through2M.Area(2,1);

% Estimated error in geometric area (cm^2)
KHCO3.CO2Through2M.AreaErr(1,1) = 0.1*mean([0.150 0.146])*pi();
KHCO3.CO2Through2M.AreaErr(3,1) = KHCO3.CO2Through2M.AreaErr(1,1);
KHCO3.CO2Through2M.AreaErr(5,1) = KHCO3.CO2Through2M.AreaErr(1,1);

KHCO3.CO2Through2M.AreaErr(2,1) = 0.1*mean([0.150 0.146])*pi();
KHCO3.CO2Through2M.AreaErr(4,1) = KHCO3.CO2Through2M.AreaErr(2,1);

% Set variable name
KHCO3.CO2Through2M.VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04';'Exp05'];

% Uncorrected potential used during chronoamperometry
KHCO3.CO2Through2M.ESet = [-1.8; -2.0; -2.1; -2.2; -2.4];

% Call ConstantPotentialCO2.m
KHCO3.CO2Through2M = ConstantPotentialCO2(KHCO3.CO2Through2M);


%% Partial current densities
% The plot functions in lines 123 - 135 require the input: 
% (XData,YData, FigNumber, Axis, XTick,YTick, XLabel, YLabel, size)

% Plot CO, FA and ethylene partial current density of experiments in 
% 0.5 M KHCO3
PCDCAll(KHCO3.CO2Through,KHCO3.CO2Through,  401, [-1.8 -0.8 -200 0], linspace(-1.8,-0.8,6),linspace(-200,0,5),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% Plot CO, FA and ethylene partial current density of experiments in 
% 2 M KHCO3
PCDCAll2M(KHCO3.CO2Through2M,KHCO3.CO2Through2M, 501, [-1.8 -0.8 -200 0], linspace(-1.8,-0.8,6),linspace(-200,0,5),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% Plot H2 partial current density and total current density of experiments
% in 0.5 M KHCO3
PCDH2(KHCO3.CO2Through,KHCO3.CO2Through,  402, [-1.8 -0.8 -600 0], linspace(-1.8,-0.8,6),linspace(-600,0,7),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% Plot H2 partial current density and total current density of experiments
% in 2M KHCO3
PCDH2(KHCO3.CO2Through2M,KHCO3.CO2Through2M, 502, [-1.8 -0.8 -600 0], linspace(-1.8,-0.8,6),linspace(-600,0,7),'Potential vs Ag/AgCl',{'Partial current density'; '(mA cm^{-2}_{geo})'},size)

% The following plot functions require the input: 
% (XData0.5MKHCO3,YData0.5MKHCO3, XData2MKHCO3, YData2MKHCO3, FigNumber, 
% Axis, XTick,YTick, XLabel, YLabel, size)

% Calculate current that is not accounted for
PlotPCDUnknownAll(KHCO3.CO2Through,KHCO3.CO2Through, KHCO3.CO2Through2M,KHCO3.CO2Through2M, 303, [-1.7 -1.1 -60 0],linspace(-1.7,-1.0,8),linspace(-60,0,7),'E_{real} (V vs Ag/AgCl)',{'CD_{Unknown}'},size)

% Total average current density
PlotPCDAvgAll(KHCO3.CO2Through,KHCO3.CO2Through, KHCO3.CO2Through2M,KHCO3.CO2Through2M, 304, [-1.7 -1.1 -700 0],linspace(-1.7,-1.0,8),linspace(-700,0,8),'E_{real} (V vs Ag/AgCl)',{'Average total current density';'(mA cm^{-2}_{geo})'},size)


%% Function files for plot

% Plot CO, FA and ethylene partial current densities for the 0.5 M KHCO3 exp
function PCDCAll(x1,y1,FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    errorbar(x1.Ereal(i,1),y1.FID_CD(i,2),y1.FID_CD_Err(i,2),y1.FID_CD_Err(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'dm')      % Ethylene
    errorbar(x1.Ereal(i,1),y1.CDCO(i,1),y1.CDCO(i,2),y1.CDCO(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'ob')                    % CO
    errorbar(x1.Ereal(i,1),y1.CDFA(i,1),y1.CDFA(i,2),y1.CDFA(i,2),y1.Ereal(i,2),y1.Ereal(i,2), '^','Color','#5f021f')   % FA
end
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y lable
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

% Legend
legend('Ethylene','CO','FA', 'Location','SouthEast')

end

% Plot CO, FA and ethylene partial current densities for the 2 M KHCO3 exp
function PCDCAll2M(x1,y1,FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    errorbar(x1.Ereal(i,1),y1.CDProp(i,1),y1.CDProp(i,2),y1.CDProp(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'sk')              % 1-Propanol
    errorbar(x1.Ereal(i,1),y1.FID_CD(i,2),y1.FID_CD_Err(i,2),y1.FID_CD_Err(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'dm')      % Ethylene
    errorbar(x1.Ereal(i,1),y1.CDCO(i,1),y1.CDCO(i,2),y1.CDCO(i,2),y1.Ereal(i,2),y1.Ereal(i,2), 'ob')                    % CO
    errorbar(x1.Ereal(i,1),y1.CDFA(i,1),y1.CDFA(i,2),y1.CDFA(i,2),y1.Ereal(i,2),y1.Ereal(i,2), '^','Color','#5f021f')   % FA
    
end
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

% Legend
legend('1-Propanol','Ethylene','CO','FA','Location','SouthEast')
end

% Plot H2 partial current densities and total current density
function PCDH2(x1,y1,FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    errorbar(x1.Ereal(i,1),y1.CDH2(i,1),y1.CDH2(i,2),y1.CDH2(i,2),y1.Ereal(i,2),y1.Ereal(i,2), '<','Color','#008631')       % H2
    errorbar(x1.Ereal(i,1),y1.CDavg30mins(i,1),y1.CDavg30mins(i,2),y1.CDavg30mins(i,2),y1.Ereal(i,2),y1.Ereal(i,2),'*k')    % Total
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;
xtickformat('%.1f')

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

% Legend
legend('H_{2}','Total','Location','SouthEast')

end

% Plot current density that is not accounted for
function PlotPCDUnknownAll(x1,y1,x2,y2, FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    plot(x1.Ereal(i,1),y1.Unaccounted(i,1), 'sk')
end

for j = 1:length(x2.ESet)
    plot(x2.Ereal(j,1),y2.Unaccounted(j,1), 'sb')
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

end

% Plot average of total current density (averaged over the last 30 mins of
% the experiment)
function PlotPCDAvgAll(x1,y1,x2,y2, FigNum, Axis, XTick, YTick, labelX, labelY, size)

fig = figure(FigNum);

hold on
for i = 1:length(x1.ESet)
    plot(x1.Ereal(i,1),y1.CDavg30mins(i,1), 'vk')
end

for j = 1:length(x2.ESet)
    plot(x2.Ereal(j,1),y2.CDavg30mins(j,1), 'vb')
end

hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Cambria';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis(Axis);
ax.XTick = XTick;
ax.YTick = YTick;

% X and Y label
xlabel(labelX)
ylabel(labelY)

% Additional figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

end

